<?php

require "../Utilities/REQUIRE_SETTINGS.php";
require "../Utilities/Message/Message.php";
require "../Utilities/Message/MessageExt.php";
require "../Utilities/Encryption/EncryptionManager.php";

$sender_username = isset($_POST['sender_user_name'])?$_POST['sender_user_name']:$_GET['sender_user_name'];
$recipient_username = isset($_POST['recipient_user_name'])?$_POST['recipient_user_name']:$_GET['recipient_user_name'];

$table_name = strtolower($sender_username . "_" . $recipient_username);

$messages_ids = getMessages($table_name);
if($messages_ids==null) {
    $table_name = strtolower($recipient_username . "_" . $sender_username);
    $messages_ids = getMessages($table_name);
}

if($messages_ids == null)
    $messages_ids = array();
else {
    $id = getLastMessage($table_name);
    $message = new Message();
    if($message->create_from_id($id,$table_name)) {
        if($recipient_username == $message->sender)
        {
            markAsRead($table_name,$sender_username);
            markAsRead($table_name,$recipient_username);
        }
    }
}

$ids = array();
foreach ($messages_ids as $message_id)
{
    $message = new Message();
    if(!$message->create_from_id($message_id,$table_name))
        continue;

    $ids[] = $message_id;

    $response[$message_id . ' message'] = decrypt($message->message);
    $response[$message_id . ' sender'] = $message->sender;
    $response[$message_id . ' date'] = $message->date;
    $response[$message_id . ' file_url'] = UPLOADING_PATH_URL . $message->file_url;
    $response[$message_id . ' file_size'] = $message->file_size;
    $response[$message_id . ' file_name'] = decrypt($message->file_name);
    $response[$message_id . ' read'] = $message->read == 1;
    $response[$message_id . ' isSent'] = strtolower($message->sender) == strtolower($sender_username);
}
    $response['success'] = 1;
    $response['message'] = "Done";
    $response['ids'] = $ids;
    die(json_encode($response));
?>