<?php

require "../Utilities/REQUIRE_SETTINGS.php";
require "../Utilities/Message/Message.php";
require "../Utilities/Message/MessageExt.php";
require "../Utilities/User/User.php";
require "../Utilities/User/UserExt.php";
require "../Utilities/Encryption/EncryptionManager.php";

$user_id = isset($_POST['user_id'])?$_POST['user_id']:$_GET['user_id'];

$current_user = new User();
$current_user->create_using_id($user_id);

$all_users = getAllUsers();
$conversations_ids = array();
$ids = array();
foreach ($all_users as $all_users_id)
{
    $user = new User();
    if(!$user->create_using_id($all_users_id))
        continue;


    $table_name = strtolower($current_user->firstname . "_" . $user->firstname);

    $messages_ids = getMessages($table_name);
    if($messages_ids==null) {
        $table_name = strtolower($user->firstname . "_" . $current_user->firstname);
        $messages_ids = getMessages($table_name);
    }

    if($messages_ids==null)
        continue;

    $messages = 0;
    $last_message_date = "1990/10/16 12:01:54";
    $last_message_text = "";
    foreach ($messages_ids as $id)
    {
        $message = new Message();
        if($message->create_from_id($id,$table_name) && $message->read==0 && $message->sender!=$current_user->firstname)
            $messages++;

        $last_message_date = $message->date;
        $last_message_text = decrypt($message->message);
    }

    $ids[] = $all_users_id;


    $response[$all_users_id . ' firstname'] = $user->firstname;
    $response[$all_users_id . ' lastname'] = $user->lastname;
    $response[$all_users_id . ' department'] = $user->department;
    $response[$all_users_id . ' email'] = $user->email;
    $response[$all_users_id . ' address'] = $user->address;
    $response[$all_users_id . ' position'] = $user->position;
    if($user->profile_photo==null||strlen($user->profile_photo) < 2)
        $response[$all_users_id . ' profile_photo'] = "";
    else
        $response[$all_users_id . ' profile_photo'] = PROFILE_PICTURE_URL_HEADER . $user->profile_photo;
    $response[$all_users_id . ' date'] = $user->date;
    $response[$all_users_id . ' unread'] = $messages;
    $response[$all_users_id . ' last_message_date'] = $last_message_date;
    $response[$all_users_id . ' last_message_text'] = $last_message_text;
}
    $response['success'] = 1;
    $response['message'] = "Done";
    $response['ids'] = $ids;
    die(json_encode($response));



?>