<?php
/**
 * Created by PhpStorm.
 * User: leon-pc
 * Date: 11/16/2016
 * Time: 10:12 AM
 */
function markAsRead($table_name,$user_name)
{
    require (REQUIRE_CONNECTION);

    $query = "UPDATE $table_name SET `read_message` = '1' WHERE `read_message` = '0' AND `Usernames` = '$user_name'";


    try {
        $stmt   = $db->prepare($query);
        $result = $stmt->execute();
    }
    catch (PDOException $ex) {
        echo $ex;
        return null;
    }

    return true;
}
function getLastMessage($table_name)
{
    require (REQUIRE_CONNECTION);

    $query = " 
            SELECT  
                *
            FROM $table_name ORDER BY `ID` DESC
        ";


    try {
        $stmt   = $db->prepare($query);
        $result = $stmt->execute();
    }
    catch (PDOException $ex) {
        echo $ex;
        return null;
    }

    while ($data = $stmt->fetch())
    {
        return $data['ID'];
    }

    return -1;
}
function getUnreadMessages($table_name)
{
    require (REQUIRE_CONNECTION);

    $query = " 
            SELECT  
                *
            FROM $table_name WHERE read = 0
        ";


    try {
        $stmt   = $db->prepare($query);
        $result = $stmt->execute();
    }
    catch (PDOException $ex) {
        echo $ex;
        return null;
    }

    $number = 0;

    while ($data = $stmt->fetch())
    {
        $number++;
    }

    return $number;
}
function getMessages($table_name)
{
    require (REQUIRE_CONNECTION);

    $query = " 
            SELECT  
                *
            FROM $table_name
        ";


    try {
        $stmt   = $db->prepare($query);
        $result = $stmt->execute();
    }
    catch (PDOException $ex) {
        return null;
    }

    $ids = array();

    while ($data = $stmt->fetch())
    {
        $ids[] = $data['ID'];
    }

    return $ids;
}
function registerMessage($sender_username,$receiver_username,$message,$attachment_url,$attachment_size,$attachment_name,$table_name = null,$trials = 0)
{
    require (REQUIRE_CONNECTION);
    if($trials==0)
        require (REQUIRE_DATE);

    if($attachment_size==null)
        $attachment_size = "0";
    if($attachment_url == null)
        $attachment_url = "null";
    if($attachment_name == null)
        $attachment_name = "null";

    $trials++;

    if($table_name == null)
        $table_name = $sender_username . "_" . $receiver_username;

    $table_name = strtolower($table_name);

    $query = "INSERT INTO $table_name
 	( Messages,Time,Usernames,file_url,file_size,file_name) VALUES 
 	( :Messages , :Time,:Usernames,:file_url,:file_size,:file_name)";

    $query_params = array(
        ':Messages' => $message,
        ':Time' => getCurrentDateString(),
        ':Usernames' => $sender_username,
        ':file_url' => $attachment_url,
        ':file_size' => $attachment_size,
        ':file_name' => $attachment_name
    );

    try {
        $stmt = $db->prepare($query);
        $result = $stmt->execute($query_params);

        return true;
    }
    catch (PDOException $ex) {
        if($trials==1)
            return registerMessage($sender_username,$receiver_username,$message,$attachment_url,$attachment_size,$attachment_name,strtolower($receiver_username . "_" . $sender_username),$trials);
        else if($trials==2)
        {
            if(!createTable(strtolower($sender_username . "_" . $receiver_username)))
                return false;
            return registerMessage($sender_username,$receiver_username,$message,$attachment_url,$attachment_size,$attachment_name,strtolower($sender_username . "_" . $receiver_username),$trials);
        }
        else
            return false;
    }
}
function createTable($table_name)
{
    require (REQUIRE_CONNECTION);

    $query = "CREATE TABLE $table_name ( `ID` INT NOT NULL AUTO_INCREMENT , `Messages` TEXT NOT NULL , `Time` TEXT NOT NULL , `Usernames` TEXT NOT NULL , `file_url` TEXT NOT NULL ,`file_size` TEXT NOT NULL ,`file_name` TEXT NOT NULL , `read_message` INT NOT NULL, PRIMARY KEY (`ID`)) ENGINE = InnoDB;";

    try {
        $stmt = $db->prepare($query);
        $result = $stmt->execute();

        return true;
    }
    catch (PDOException $ex) {
        return false;
    }
}
